package cn.com.duiba.paycenter.enums.equity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 权益业务类型
 * @author lizhi
 * @date 2023/4/10 11:38 AM
 */
@Getter
@AllArgsConstructor
public enum EquityBizTypeEnum {
    DUI_BA_POINTS_ALIPAY_COUPON(1, "积分商城支付宝立减金"),
    DXT_WX_COUPON(2, "兑信通微信立减金"),
    
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
    
    private static final Map<Integer, EquityBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(EquityBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    public static EquityBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
