/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.PayChargeExtraParams;
import cn.com.duiba.paycenter.result.PayChargeResult;
import cn.com.duiba.paycenter.service.PayChargeService;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;

public class PayChargeServiceClient {
    private PayChargeService payChargeService;

    public RpcResult<PayChargeResult> chargeMoneyByManual(Long developerId, Long manualApplyId, Long money, PayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("relationId", manualApplyId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayChargeResult ret = this.payChargeService.chargeMoneyByManual(developerId, manualApplyId, money, sign, p);
            return new RpcResult<PayChargeResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayChargeResult>(e);
        }
    }

    public RpcResult<PayChargeResult> chargeMoneyByOnline(Long developerId, Long onlineApplyId, Long money, PayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("relationId", onlineApplyId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayChargeResult ret = this.payChargeService.chargeMoneyByOnline(developerId, onlineApplyId, money, sign, p);
            return new RpcResult<PayChargeResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayChargeResult>(e);
        }
    }

    public RpcResult<PayChargeResult> reduceMoneyByManual(Long developerId, Long manualApplyId, Long money, PayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("developerId", developerId + "");
            params.put("relationId", manualApplyId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayChargeResult ret = this.payChargeService.reduceMoneyByManual(developerId, manualApplyId, money, sign, p);
            return new RpcResult<PayChargeResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayChargeResult>(e);
        }
    }

    public void setPayChargeService(PayChargeService payChargeService) {
        this.payChargeService = payChargeService;
    }
}

