package cn.com.duiba.paycenter.dto.payment.charge.wxpay.coupon;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.List;

/**
 * 微信立减金发券批次
 *
 * @author zouwx
 * @date 2022/12/06
 */
public class WxStockUseRuleDTO implements Serializable {

    private static final long serialVersionUID = -1674014926815400322L;

    /**
     * 发放总上限
     */
    @JSONField(name = "max_coupons")
    private Integer maxCoupons;

    /**
     * 总预算
     */
    @JSONField(name = "max_amount")
    private Integer maxAmount;

    /**
     * 单天发放上限金额
     */
    @JSONField(name = "max_amount_by_day")
    private Integer maxAmountByDay;

    /**
     * 固定面额批次特定信息
     */
    @JSONField(name = "fixed_normal_coupon")
    private FixedNormalCoupon fixedNormalCoupon;


    /**
     * 单个用户可领个数
     */
    @JSONField(name = "max_coupons_per_user")
    private Integer maxCouponsPerUser;

    /**
     * 优惠券类型
     */
    @JSONField(name = "coupon_type")
    private String couponType;

    /**
     * 订单优惠标记
     */
    @JSONField(name = "goods_tag")
    private List<String> goodsTag;

    /**
     * 交易类型
     */
    @JSONField(name = "trade_type")
    private List<String> tradeType;

    /**
     * 是否可以叠加其他优惠
     */
    @JSONField(name = "combine_use")
    private Boolean combineUse;

    public Integer getMaxCoupons() {
        return maxCoupons;
    }

    public void setMaxCoupons(Integer maxCoupons) {
        this.maxCoupons = maxCoupons;
    }

    public Integer getMaxAmount() {
        return maxAmount;
    }

    public void setMaxAmount(Integer maxAmount) {
        this.maxAmount = maxAmount;
    }

    public Integer getMaxAmountByDay() {
        return maxAmountByDay;
    }

    public void setMaxAmountByDay(Integer maxAmountByDay) {
        this.maxAmountByDay = maxAmountByDay;
    }

    public FixedNormalCoupon getFixedNormalCoupon() {
        return fixedNormalCoupon;
    }

    public void setFixedNormalCoupon(FixedNormalCoupon fixedNormalCoupon) {
        this.fixedNormalCoupon = fixedNormalCoupon;
    }

    public Integer getMaxCouponsPerUser() {
        return maxCouponsPerUser;
    }

    public void setMaxCouponsPerUser(Integer maxCouponsPerUser) {
        this.maxCouponsPerUser = maxCouponsPerUser;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public List<String> getGoodsTag() {
        return goodsTag;
    }

    public void setGoodsTag(List<String> goodsTag) {
        this.goodsTag = goodsTag;
    }

    public List<String> getTradeType() {
        return tradeType;
    }

    public void setTradeType(List<String> tradeType) {
        this.tradeType = tradeType;
    }

    public Boolean getCombineUse() {
        return combineUse;
    }

    public void setCombineUse(Boolean combineUse) {
        this.combineUse = combineUse;
    }

    /**
     * 固定面额批次特定信息
     *
     * @author zouwx
     * @date 2022/12/06
     */
    public static class FixedNormalCoupon implements Serializable{

        private static final long serialVersionUID = -2552731156531397095L;

        /**
         * 优惠券面额
         */
        @JSONField(name = "coupon_amount")
        private Integer couponAmount;

        /**
         * 门槛金额
         */
        @JSONField(name = "transaction_minimum")
        private Integer transactionMinimum;

        public Integer getCouponAmount() {
            return couponAmount;
        }

        public void setCouponAmount(Integer couponAmount) {
            this.couponAmount = couponAmount;
        }

        public Integer getTransactionMinimum() {
            return transactionMinimum;
        }

        public void setTransactionMinimum(Integer transactionMinimum) {
            this.transactionMinimum = transactionMinimum;
        }
    }
}
