package cn.com.duiba.paycenter.dto.equity.request.wx.transfer;

import cn.com.duiba.paycenter.dto.equity.request.EquityWxTransferDetailRequest;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 微信-商家转账到零钱-发放参数
 * @author lizhi
 * @date 2023/4/24 1:40 PM
 */
@Data
public class EquityWxInitiateBatchTransferRequest implements Serializable {

    private static final long serialVersionUID = -4786977124811764978L;

    /**
     * 商户ID
     */
    @NotBlank(message = "mchId must not be null")
    @Size(max = 32, message = "mchId不能超过32")
    private String mchId;
    
    /**
     * 商户appid
     * 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     * 必填，string(32)
     */
    @NotBlank(message = "appId must not be null")
    @Size(max = 32, message = "appId不能超过32")
    private String appId;

    /**
     * 批次名称
     * 说明：该笔批量转账的名称
     * 必填，string(32)
     */
    @NotBlank(message = "batchName must not be null")
    @Size(max = 32, message = "batchName不能超过32")
    private String batchName;

    /**
     * 批次备注
     * 说明：转账说明，UTF8编码，最多允许32个字符
     * 必填，string(32)
     */
    @NotBlank(message = "batchRemark must not be null")
    @Size(max = 32, message = "batchRemark不能超过32")
    private String batchRemark;

    /**
     * 转账总金额
     * 说明：转账金额单位为“分”。转账总金额必须与批次内所有明细转账金额之和保持一致，否则无法发起转账操作
     * 必填
     */
    @NotNull(message = "totalAmount must not be null")
    private Long totalAmount;

    /**
     * 转账总笔数
     * 说明：一个转账批次单最多发起一千笔转账。转账总笔数必须与批次内所有明细之和保持一致，否则无法发起转账操作
     * 必填
     */
    @NotNull(message = "totalNum must not be null")
    @Min(value = 1, message = "totalNum不能小于1")
    @Max(value = 1000, message = "totalNum不能大于1000")
    private Integer totalNum;

    /**
     * 转账明细列表
     * 说明：发起批量转账的明细列表，最多一千笔
     * 必填
     */
    @Valid
    @NotNull(message = "transferDetailList must not be null")
    @Size(min = 1, max = 1000, message = "transferDetailList size error")
    private List<EquityWxTransferDetailRequest> transferDetailList;

    /**
     * 转账场景ID
     * 说明：选填，指定该笔转账使用的转账场景ID
     * 选填，string(36)
     * <a herf="https://pay.weixin.qq.com/docs/merchant/products/batch-transfer-to-balance/operation.html#_5-%E5%9C%BA%E6%99%AF%E7%AE%A1%E7%90%86">官方文档</a>
     */
    @Size(max = 36, message = "transferSceneId不能超过36")
    private String transferSceneId;
}
