package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 支付宝预授权支付请求类
 * 
 * @author AI Assistant
 * @date 2024/12/19
 */
public class AlipayPreAuthChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -5002740011734334299L;


     /**
     * 商户自定义的预授权订单号
     */
    private String outOrderNo;

    /**
     * 支付成功通知接收url
     * 非必填，不传则通知到默认地址
     */
    private String notifyUrl;

    /**
     * 订单绝对超时时间
     * 预授权订单允许的最晚授权时间，逾期将关闭该笔订单。取值范围：1m～15d。m-分钟，h-小时，d-天。 该参数数值不接受小数点， 如 1.5h，可转换为90m。
     * 默认为15m。
     * 非必传
     */
    private String timeExpire="30m";

    /**
     * 预授权产品码，固定值：PREAUTH_PAY
     */
    private String productCode = "PREAUTH_PAY";

    /**
     * 预授权金额，单位为分
     */
    @NotNull(message = "预授权金额不能为空")
    private Integer preAuthAmount;


    /**
     * 预授权订单标题
     */
    @Size(max = 256, message = "预授权订单标题不能超过256")
    private String orderTitle;




    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }



    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }


    public Integer getPreAuthAmount() {
        return preAuthAmount;
    }

    public void setPreAuthAmount(Integer preAuthAmount) {
        this.preAuthAmount = preAuthAmount;
    }


    public String getOutOrderNo() {
        return outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public String getOrderTitle() {
        return orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public String getTimeExpire() {
        return timeExpire;
    }

    public void setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
    }
}