package cn.com.duiba.paycenter.dto.payment.charge.citic;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeNotifyResponse;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * @author liukai
 * @Desc 开发者响应体信息
 * @date 2020/03/13
 */
public class CiticChargeNotifyResponse extends BaseChargeNotifyResponse {
    private static final long serialVersionUID = 8975490665664572928L;

    private Long appId;

    private String errMsg;

    private PayResponse payResponse;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public PayResponse getPayResponse() {
        return payResponse;
    }

    public void setPayResponse(PayResponse payResponse) {
        this.payResponse = payResponse;
    }

    public static class PayResponse implements Serializable {
        private static final long serialVersionUID = 8270567158806170208L;
        //信息标识
        @JSONField(name = "RETCODE")
        private String retCode;
        //返回标识信息描述
        @JSONField(name = "RETMSG")
        private String retMsg;
        //交易金额
        @JSONField(name = "TRANAMT")
        private String tranAmt;
        //商户名称
        @JSONField(name = "MERNAME")
        private String merName;
        //交易完成时间
        @JSONField(name = "TRANTIME")
        private String tranTime;
        //付款银行名称
        @JSONField(name = "PAYBANKNAME")
        private String payBankName;
        //交易商户订单号
        @JSONField(name = "MERORDERNO")
        private String merOrderNo;
        //交易结果 01：处理中 02：交易成功 03：交易失败 04：交易超时
        @JSONField(name = "STT")
        private String stt;

        public String getRetCode() {
            return retCode;
        }

        public void setRetCode(String retCode) {
            this.retCode = retCode;
        }

        public String getRetMsg() {
            return retMsg;
        }

        public void setRetMsg(String retMsg) {
            this.retMsg = retMsg;
        }

        public String getTranAmt() {
            return tranAmt;
        }

        public void setTranAmt(String tranAmt) {
            this.tranAmt = tranAmt;
        }

        public String getMerName() {
            return merName;
        }

        public void setMerName(String merName) {
            this.merName = merName;
        }

        public String getTranTime() {
            return tranTime;
        }

        public void setTranTime(String tranTime) {
            this.tranTime = tranTime;
        }

        public String getPayBankName() {
            return payBankName;
        }

        public void setPayBankName(String payBankName) {
            this.payBankName = payBankName;
        }

        public String getMerOrderNo() {
            return merOrderNo;
        }

        public void setMerOrderNo(String merOrderNo) {
            this.merOrderNo = merOrderNo;
        }

        public String getStt() {
            return stt;
        }

        public void setStt(String stt) {
            this.stt = stt;
        }
    }
}