package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import cn.com.duiba.paycenter.enums.BizTypeEnum;

import java.io.Serializable;

/**
 * 招商银行-掌上生活-开放平台-H5支付-支付回调
 *
 * @author songp
 * @date 2024/2/19 9:43 上午
 */
public class CmbLifePayNotifyResponse implements Serializable{

    private static final long serialVersionUID = 8535820434069399310L;

    /**
     * 流程是否成功
     */
    private boolean success;

    /**
     * 用户支付是否成功
     */
    private boolean chargeSuccess;

    /**
     * @see BizTypeEnum
     */
    private Integer bizType;

    /**
     * 星速台订单号
     */
    private String bizOrderNo;

    /**
     * 合作方订单号
     */
    private String billNo;

    /**
     * 掌上生活确认支付结果的时间，格式yyyyMMddHHmmss
     */
    private String payDate;

    /**
     * 说明文字/错误信息
     */
    private String message;

    /**
     * 订单金额（单位为分）
     */
    private String amount;

    /**
     * 订单积分
     */
    private String bonus;

    /**
     * 支付方式，从左往右，第一位：招行贷记，第二位：招行借记，第三位：招行外贷记，第四位：招行外借记
     */
    private String payType;

    /**
     * 交易参考号，支付失败时不存在，交易以此对账
     */
    private String refNum;

    /**
     * 屏蔽卡号，积分支付时不存在
     */
    private String shieldCardNo;


    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isChargeSuccess() {
        return chargeSuccess;
    }

    public void setChargeSuccess(boolean chargeSuccess) {
        this.chargeSuccess = chargeSuccess;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getPayDate() {
        return payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getBonus() {
        return bonus;
    }

    public void setBonus(String bonus) {
        this.bonus = bonus;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getRefNum() {
        return refNum;
    }

    public void setRefNum(String refNum) {
        this.refNum = refNum;
    }

    public String getShieldCardNo() {
        return shieldCardNo;
    }

    public void setShieldCardNo(String shieldCardNo) {
        this.shieldCardNo = shieldCardNo;
    }
}
