package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 *  招商银行-掌上生活-开放平台-H5支付-支付查询response
 *
 * @author songp
 * @date 2024/2/18 9:12 下午
 */
public class CmbLifePayQueryResponse implements Serializable {

    private static final long serialVersionUID = 8535820434069399311L;

    /**
     * 星速台默认错误码
     */
    public static final String DEFAULT_ERROR_CODE = "99999";

    public static final String SUCCESS_CODE = "1000";

    /**
     * 返回码 1000：查询成功，9501：参数错误，1001：查询异常，2000：订单不存在
     */
    private String respCode;

    /**
     * 返回话术
     */
    private String respMsg;

    /**
     * 时间戳，格式yyyyMMddHHmmss
     */
    private String date;

    /**
     * 金额（单位为分）
     */
    private int amount;

    /**
     * 积分
     */
    private int bonus;

    /**
     * 创建订单时间yyyy-MM-dd HH:mm:ss
     */
    private String createTime;

    /**
     * 支付结果，1：待支付，2：成功，3：失败，4：未知，5：处理中
     */
    private int result;

    /**
     * 退货金额（单位为分）
     */
    private String refundedAmount;

    /**
     * 退货结果 1：部分退货，2：全额退货
     */
    private String refundedStatus;

    /**
     * 交易参考号，支付失败时不存在，交易以此对账
     */
    private String refNum;

    /**
     * 屏蔽卡号，积分支付时不存在
     * 4391********9733
     */
    private String shieldCardNo;

    /**
     * 支付方式，从左往右，第一位：招行贷记，第二位：招行借记，第三位：招行外贷记，第四位：招行外借记
     * 1000
     */
    private String payType;

    /**
     * 掌上生活密钥对别名
     */
    private String cmbKeyAlias;

    /**
     * 签名，具体详见《签名与验签》文档
     */
    private String sign;

    public String getRespCode() {
        return respCode;
    }

    public void setRespCode(String respCode) {
        this.respCode = respCode;
    }

    public String getRespMsg() {
        return respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getBonus() {
        return bonus;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public int getResult() {
        return result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getRefundedAmount() {
        return refundedAmount;
    }

    public void setRefundedAmount(String refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public String getRefundedStatus() {
        return refundedStatus;
    }

    public void setRefundedStatus(String refundedStatus) {
        this.refundedStatus = refundedStatus;
    }

    public String getRefNum() {
        return refNum;
    }

    public void setRefNum(String refNum) {
        this.refNum = refNum;
    }

    public String getShieldCardNo() {
        return shieldCardNo;
    }

    public void setShieldCardNo(String shieldCardNo) {
        this.shieldCardNo = shieldCardNo;
    }

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getCmbKeyAlias() {
        return cmbKeyAlias;
    }

    public void setCmbKeyAlias(String cmbKeyAlias) {
        this.cmbKeyAlias = cmbKeyAlias;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }
}
