package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;

/**
 * 招商银行-掌上生活-开放平台-H5支付-下单支付request
 * <link>https://open.cmbchina.com/Platform/#/resource/document/payAPI<link/>
 *
 * @author songp
 * @date 2024/2/18 10:36 上午
 */
public class CmbLifePayRequest extends BaseChargeRequest {
//
//    /**
//     * 合作方唯一ID，32位定长
//     */
//    @NotNull(message = "合作方唯一ID不能为空")
//    private String mid;
//
//    /**
//     * 应用唯一ID，32位定长
//     */
//    @NotNull(message = "应用唯一ID不能为空")
//    private String aid;

    /**
     * 订单名称（建议十个字符内）
     */
    @NotNull(message = "订单名称不能为空")
    private String productName;

    /**
     * 掌上生活客户端支付结果重定向页面地址，App支付时不需要传入，需开通白名单权限，请提前告知相关对接人员
     */
    private String returnUrl;

    /**
     * 后台通知接口地址，需要开通网络权限，请提前告知相关对接人员，请使用https协议
     */
    @NotNull(message = "后台通知接口地址不能为空")
    private String notifyUrl;

    /**
     * 订单详情页，用于订单中心展示订单详情，请使用https协议
     */
    private String orderDetailUrl;

    /**
     * 剩余的可支付时间(秒)，建议24小时内，最长7天
     */
    @NotNull(message = "剩余的可支付时间(秒)不能为空")
    private String payPeriod;
//
//    /**
//     * 合作方密钥对别名
//     * CO_PUB_KEY_SM2
//     */
//    private String keyAlias;
//
//    /**
//     * 掌上生活密钥对别名
//     */
//    private String cmbKeyAlias;

    /**
     * ip
     */
    private String ip;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOrderDetailUrl() {
        return orderDetailUrl;
    }

    public void setOrderDetailUrl(String orderDetailUrl) {
        this.orderDetailUrl = orderDetailUrl;
    }

    public String getPayPeriod() {
        return payPeriod;
    }

    public void setPayPeriod(String payPeriod) {
        this.payPeriod = payPeriod;
    }
}
