package cn.com.duiba.paycenter.dto.payment.charge.ningbobank.refund;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 退款请求
 *
 * @author fja
 * @date 2022-03-17
 */
public class NbcbRefundRequestDto implements Serializable {
    @NotNull(message = "主订单号不能为空")
    private String bizOrderNo;
    /**
     * 售后金额
     */
    @NotNull(message = "金额不能为空")
    @Min(value = 1, message = "金额必须大于1分")
    private Integer transAmt;
    /**
     * 开发者用户id
     */
    private String partnerUserId;
    /**
     * 主订单生成时间
     */
    private Date merDate;
    /**
     * 子订单
     */
    private Long ordersItemId;


    public Integer getTransAmt() {
        return transAmt;
    }

    public void setTransAmt(Integer transAmt) {
        this.transAmt = transAmt;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Date getMerDate() {
        return merDate;
    }

    public void setMerDate(Date merDate) {
        this.merDate = merDate;
    }

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }
}
