package cn.com.duiba.paycenter.dto.payment.charge.shenzhenumsunionpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 深圳银联对接天满saas服务平台的支付
 *
 * @author zhangdaqing
 * @date 2023/07/13
 */
public class UnionPayUmsRefundRequest implements Serializable {

    /**
     * 退款金额
     */
    @NotNull(message = "退款金额不能为空")
    private Long refundAmount;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String bizOrderNo;


    /**
     * 回调url
     */
    private String callbackUrl;

    /**
     * 业务方类型
     */
    private String bizType;

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }


    public Long getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(Long refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }


}
