package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.paycenter.validator.ChannelEnumCheck;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author liugq
 * @date 2020/03/22
 */
public class WxCloseOrderRequest implements Serializable {
    private static final long serialVersionUID = 8912989507224278005L;

    /**
     * 支付渠道
     * @see cn.com.duiba.paycenter.enums.ChannelEnum
     */
    @NotNull(message = "channelType不能为空")
    @ChannelEnumCheck
    private String channelType;
    /**
     * 兑吧appId
     */
    @NotNull(message = "appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 -- 必传参数
     * @see cn.com.duiba.api.enums.SubjectTypeEnum
     */
    @NotNull
    private String subjectType;

    /**
     * 支付订单号 -- 必传参数
     */
    @NotNull
    private String payOrderNo;

    
    public String getChannelType() {
        return channelType;
    }

    
    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    
    public String getSubjectType() {
        return subjectType;
    }

    
    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getPayOrderNo() {
        return payOrderNo;
    }

    public void setPayOrderNo(String payOrderNo) {
        this.payOrderNo = payOrderNo;
    }
}
