package cn.com.duiba.paycenter.dto.payment.charge.xib.refund;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 厦门国际银行退款请求
 *
 * @author zouwx
 * @date 2022/10/31
 */
public class XibRefundRequestDTO implements Serializable {

    private static final long serialVersionUID = -1937052441520355905L;

    /**
     * 退款金额
     */
    @NotNull(message = "退款金额不能为空")
    private Long txnAmt;

    private Integer bizType;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String bizOrderNo;

    /**
     * 子订单
     */
    private Long ordersItemId;

    public Long getTxnAmt() {
        return txnAmt;
    }

    public void setTxnAmt(Long txnAmt) {
        this.txnAmt = txnAmt;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public Long getOrdersItemId() {
        return ordersItemId;
    }

    public void setOrdersItemId(Long ordersItemId) {
        this.ordersItemId = ordersItemId;
    }
}
