package cn.com.duiba.plugin.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 插件活动用户领奖验证的验证策略
 * Created by sty on 12/18/17.
 */
public enum PluginJoinVerificyModeEnum {

    NGAMEMUTIRANK(1,"多游戏排行榜验证"),
    OPTIONNUMRANK(2,"奖项数量排行榜验证"),
    UNLOCKINGRECORD(3, "解锁记录验证"),
    NGAMEMUTIRANKSCORE(4,"排行榜最低分数验证"),
    DOCALLSCORE(5,"爱奇艺定制活动打call分数校验"),
    GAME_YESTERDAY_RANK(6, "游戏昨日排行榜验证"),
    FRIEND_POINTS(7, "转转好友力值解锁"),
    GAME_LAST_WEEK_RANK(8, "游戏上周排行榜验证"),
    NEW_USER_COLLECT(21, "新人福利集卡验证"),
    WELFARE_TASK(10, "微博发财日红包校验"),
    CMBC(11, "招商银行活动宝箱校验"),
    LOTTERY_BET_VICTORY_TIMES(12, "博彩活动胜场次数"),
    QQ_WALLET_USED_CREDITS(13, "QQ钱包世界杯插件兑换"),
    PROYA_INVITATION(14, "珀莱雅助力邀请"),
    PK_PRIZE_CHECK(15, "pk活动发奖校验"),
    IQIYI_NADOU_CHECK(16,"爱奇艺纳豆活动校验"),
    DOU_MI_FIXED_DATE_CHECK(17, "斗米签到固定日期校验"),
    DOU_MI_DAILY_TASK_CHECK(18, "斗米签到每日任务校验"),
    MEIPIAN_DISCRETE_SIGN_CHECK(19,"美篇签到活动发奖校验（非连续签到奖）"),
    WASTON_SIGN_CHECK(20,"屈臣氏签到活动发奖校验（累计天数）"),
    MEIPIAN_LUCKY_PRIZE_CHECK(22,"美篇签到活动发奖校验（666元幸运奖）"),
    KOOLEARN_RANK_PRIZE_CHECK(23,"新东方排行榜开奖校验"),
    YINGYING_AWARD_PRIZE_CHECK(24,"盈盈有钱开大奖校验"),
    QQ_MUSIC_PLUGIN_TWO_PRIZE_CHECK(25,"qq音乐插件二开奖校验"),
    QQ_MUSIC_PLUGIN_THREE_PRIZE_CHECK(26,"qq音乐插件三开奖校验"),
    PGYER_SIGN_PRIZE(27,"澳觅app签到抽奖校验"),
    PGYER_TASK_FASHION_LIFE(28,"澳觅app任务列表时尚生活校验"),
    PGYER_TASK_TAKE_OUT(29,"澳觅app任务列表外卖下单校验"),
    PGYER_TASK_GROUP_PURCHASE(30,"澳觅app任务列表团购下单校验"),
    GAME_LAST_MONTH_RANK(31, "游戏上月排行榜验证"),
    DARLING_COLLECT_CARD_NORMAL_USER(32,"达令家集卡开奖校验-普调用户"),
    DARLING_COLLECT_CARD_VIP_USER(33,"达令家集卡开奖校验-高级用户"),
    QINGTING_FM(34,"蜻蜓FM会员日活动校验"),
    WECHAT_SUBSCRIBE_PRIZE_CHECK(35,"微信强制关注开奖校验"),
    ;

    private Integer code;
    private String desc;

    private static Map<Integer,PluginJoinVerificyModeEnum> typeMap = new HashMap<>();
    static{
        for(PluginJoinVerificyModeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    PluginJoinVerificyModeEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static PluginJoinVerificyModeEnum getVerificyModeByCode(Integer code){
        return typeMap.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}