package cn.com.duiba.plugin.center.api.remoteservice.plugin;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.plugin.center.api.request.credits.AddCreditsRequest;
import cn.com.duiba.plugin.center.api.request.credits.QueryAnswerRequest;
import cn.com.duiba.plugin.center.api.request.credits.SubCreditsRequest;
import cn.com.duiba.plugin.center.api.response.CreditsPluginAnswerResponse;
import cn.com.duiba.plugin.center.api.response.CreditsPluginResponse;

/**
 * 积分服务 插件工具
 * 支持扣积分 加积分操作
 * Created by hww on 2019/3/20 10:56.
 */
@AdvancedFeignClient
public interface RemoteCreditsPluginService {

    /**
     * 扣积分服务
     * 提供两种获取扣积分结果的方式
     * 1.执行入参中的callbackTopic,callbackTag,会将最终的扣积分结果以mq消息发送到该topic
     * 2.根据此接口返回的orderNum调用 {@link #queryAnswer} 或者 {@link #queryCreditsAnswer} 接口获取扣积分进度(处理中，失败，成功)
     * 上游业务方拿到扣积分结果后，根据业务执行情况，最终都必须调用{@link #notifyDeveloper}接口 通知开发者最终结果
     * 官方扣积分文档: http://docs.duiba.com.cn/tech_doc_book/server/consume_credits_api.html
     * @param request
     * @return
     */
    CreditsPluginResponse subCredits(SubCreditsRequest request);

    /**
     * 加积分服务
     * 提供两种获取扣积分结果的方式
     * 1.执行入参中的callbackTopic,callbackTag,会将最终的扣积分结果以mq消息发送到该topic
     * 2.根据此接口返回的orderNum调用 {@link #queryCreditsAnswer} 接口获取扣积分进度(处理中，失败，成功)
     * 官方加积分文档: http://docs.duiba.com.cn/tech_doc_book/server/add_credits_api.html
     * @param request
     * @return
     */
    CreditsPluginResponse addCredits(AddCreditsRequest request);

    /**
     * 查询扣积分结果
     * @param orderNum
     * @return
     */
    CreditsPluginAnswerResponse queryAnswer(String orderNum);

    /**
     * 查询积分操作进度
     * @param request
     * @return
     */
    CreditsPluginAnswerResponse queryCreditsAnswer(QueryAnswerRequest request);

    /**
     * 将扣积分最终结果同时开发者
     * @param orderNum
     * @param finalResult
     */
    void notifyDeveloper(String orderNum, boolean finalResult);

}
