package cn.com.duiba.plugin.center.api.response;

import java.io.Serializable;

/**
 * Created by hww on 2019/3/20 11:21.
 */
public class CreditsPluginResponse implements Serializable {

    private static final long serialVersionUID = 4142319127981706202L;

    /** 子订单id 查询信息唯一凭着 */
    private String orderNum;
    /** 错误信息 下单失败返回 */
    private String errorMsg;

    public static CreditsPluginResponse success(String orderNum) {
        return new CreditsPluginResponse(orderNum, null);
    }

    public static CreditsPluginResponse fail(String errorMsg) {
        return new CreditsPluginResponse(null, errorMsg);
    }

    private CreditsPluginResponse(String orderNum, String errorMsg) {
        this.orderNum = orderNum;
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return errorMsg == null;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }




}
