package cn.com.duiba.plugin.center.api.enums;

/**
 * ClassName:PluginCenterErrorEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 错误码 统一定义   规范参考http://cf.dui88.com/pages/viewpage.action?pageId=7676317
 * @date 创建时间：2018/3/14  11:23
 * @since JDK 1.8
 **/
public enum PluginCenterErrorEnum {

    CODE_2005001001("2005001001","插件创建订单异常"),
    CODE_2005001002("2005001002","idmaker异常"),
    CODE_2005001003("2005001003","插件配置查询异常"),
    CODE_2005001004("2005001004","插件id不正确或者插件已关闭"),
    CODE_2005001005("2005001005","插件直接发奖失败"),
    CODE_2005001006("2005001006","redis 连接异常") ,
    CODE_2005001007("2005001007","插件查询失败"),


    CODE_2005002001("2005002001", "开发者用户id不能为空"),
    CODE_2005002002("2005002002", "应用id不能为空"),
    CODE_2005002003("2005002003", "活动id不能为空"),
    CODE_2005002004("2005002004", "活动类型不能为空"),
    CODE_2005002005("2005002005", "兑吧用户id不能为空"),
    CODE_2005002006("2005002006", "request解析参数不能为空"),
    CODE_2005002007("2005002007", "奖品类型不能为空"),
    CODE_2005002008("2005002008", "商品id不能为空"),
    CODE_2005002009("2005002009", "商品面值不能为空"),
    CODE_2005002010("2005002010", "奖品名称不能为空"),
    CODE_2005002011("2005002011", "积分面值必须大于0"),
    CODE_2005002012("2005002012", "活动子订单不合法"),

    ;

    //错误码
    private String code;
    //错误信息
    private String msg;


    PluginCenterErrorEnum(String code,String msg){
        this.code =code;
        this.msg =msg;
    }
    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
