package cn.com.duiba.plugin.center.api.enums;

import java.util.Calendar;
import java.util.Date;

public enum PopupTimeAreaEnum {


    /** 时间段 00:30 -- 06:30 */
    FIRST("00:30-06:30", 0),
    /** 时间段 06:30 -- 12:30 */
    SECOND("06:30-12:30", 1),
    /** 时间段 12:30 -- 18:30 */
    THIRD("12:30-18:30", 2),
    /** 时间段 18:30 -- 00:30 */
    FOURTH("18:30-00:30", 3)
    ;

    /** 00:30 到当天0点的毫秒数 */
    private static long FIRST_NODE = 1800 * 1000;
    /** 06:30 到当天0点的毫秒数 */
    private static long SECOND_NODE = (6 * 3600 + 1800) * 1000;
    /** 12:30 到当天0点的毫秒数 */
    private static long THIRD_NODE = (12 * 3600 + 1800) * 1000;
    /** 18:30 到当天0点的毫秒数 */
    private static long FOURTH_NODE = (18 * 3600 + 1800) * 1000;

    /** 时间段描述 */
    private String desc;
    /** 对应时间段代号 */
    private Integer code;

    PopupTimeAreaEnum(String desc, Integer code) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    /**
     * 通过时间获取对应的时间段枚举类
     * @param date
     * @return
     */
    public static PopupTimeAreaEnum getEnumByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        long originDate = calendar.getTimeInMillis();
        long dateTime = date.getTime();
        long subTime = dateTime - originDate;
        if (subTime > FOURTH_NODE) {
            return FOURTH;
        } else if (subTime > THIRD_NODE) {
            return THIRD;
        } else if (subTime > SECOND_NODE) {
            return SECOND;
        } else if (subTime > FIRST_NODE) {
            return FIRST;
        } else {
            return FOURTH;
        }
    }
}
