package cn.com.duiba.plugin.center.api.enums;

/**
 * ClassName:RedisKeySpace<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 用于管理使用Redis的所有key前缀，避免业务key重复
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 * @date 创建时间：2018/3/13  17:19
 * @since JDK 1.8
 **/
public enum RedisKeySpace {

    K001("插件配置"),
    K002("插件订单缓存"),
    K003("时间段内首页弹层活动曝光记录"),
    K004("插件活动dto缓存key"),
    K005("所有开启的插件活动"),
    ;

    /** 活动中心对应的 K007 迁移插件用 */
    public static final String AC_KEY_007 = "AC_K007_";

    /**
     * 应用名称
     */
    private static final String SPACE = "PC";

    private String desc;

    RedisKeySpace(String description) {
        this.desc = description;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
