package cn.com.duiba.plugin.center.api.request;

import cn.com.duiba.biz.tool.duiba.dto.RequestParams;
import cn.com.duiba.plugin.center.api.enums.PlaceOrderApiEnum;

/**
 * 发放积分奖励请求类
 * 1.可以通过needExchangeRecord字段指定是否生成兑换记录
 * 2.如果需要发奖结果回调，可以指定回调topic和tag
 * Created by hww on 2019/2/21 4:44 PM.
 */
public class PlaceOrderByCreditsRequest implements PlaceOrderRequest {

    private static final long serialVersionUID = -6183335521288723762L;

    /** 应用id 必传 */
    private Long appId;
    /** 兑吧用户id 必传 */
    private Long consumerId;
    /** 开发者用户id 必传 */
    private String partnerUserId;
    /** 活动id 必传 */
    private Long activityId;
    /** 活动类型 必传 */
    private String activityType;
    /** 活动名称 非必传 */
    private String activityTitle;
    /** 奖项名称 必传 */
    private String prizeName;
    /** 积分数 必传 */
    private Long credits;
    /** RequestParams.parse()方法解析request  非必传 */
    private RequestParams requestParams;
    /** 是否需要生成兑换记录 非必传 */
    private boolean needExchangeRecord;
    /**
     * 兑换记录来源标签字段 非必传
     * 生成兑换记录时使用，用于实现查询单个记录的兑换记录功能
     * 参考: http://cf.dui88.com/pages/viewpage.action?pageId=7682671
     * */
    private Long exchangeRecordOrigin;
    /** 出奖结果回调topic 非必传 */
    private String callbackTopic;
    /** 出奖结果回调tag 非必传 */
    private String callbackTag;
    /** 需要回调的业务参数 */
    private String transfer;

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityType() {
        return activityType;
    }

    public String getActivityTitle() {
        return activityTitle;
    }

    public void setActivityTitle(String activityTitle) {
        this.activityTitle = activityTitle;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public RequestParams getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public boolean isNeedExchangeRecord() {
        return needExchangeRecord;
    }

    public void setNeedExchangeRecord(boolean needExchangeRecord) {
        this.needExchangeRecord = needExchangeRecord;
    }

    public Long getExchangeRecordOrigin() {
        return exchangeRecordOrigin;
    }

    public void setExchangeRecordOrigin(Long exchangeRecordOrigin) {
        this.exchangeRecordOrigin = exchangeRecordOrigin;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    @Override
    public String getApiMethodName() {
        return PlaceOrderApiEnum.PLACE_CREDITS.name();
    }
}
