package cn.com.duiba.plugin.center.api.request.credits;

import cn.com.duiba.api.enums.ActivityOrderStutsEnum;
import cn.com.duiba.biz.tool.duiba.dto.RequestParams;

import java.io.Serializable;

/**
 * Created by hww on 2019/4/1 14:24.
 */
public class AddCreditsRequest implements Serializable {

    private static final long serialVersionUID = -7212039068489902687L;

    /**
     * 订单id 可以基于此订单进行加积分操作 非必传
     * 订单库表为 activity_order_con.tb_trade_center_activity_order_XXXX
     * 订单的add_credits_status必须为初始化状态 即 add_credits_status = 0;
     * @see ActivityOrderStutsEnum#ADD_CREDITS_INIT
     * */
    private String orderNum;

    /** 积分数 必传 */
    private Long credits;
    /** 应用id 必传 */
    private Long appId;
    /** 兑吧用户id 必传 */
    private Long consumerId;
    /** 开发者用户id 必传 */
    private String partnerUserId;

    /*  ------  两个id必传一个 ↓  ------ */
    /** 兑吧活动id 必传1/2 */
    private Long activityId;
    /** 入库活动id 必传1/2 */
    private Long operatingActivityId;
    /*  ------  两个id必传一个 ↑ ------ */

    /** 活动类型 必传 */
    private String activityType;

    /** 活动名称 非必传 */
    private String activityTitle;
    /** 奖项id 非必传 */
    private Long prizeId;
    /** 奖项名称 非必传 */
    private String prizeName;
    /** RequestParams.parse()方法解析request  非必传 */
    private RequestParams requestParams;
    /** 结果回调topic 非必传 */
    private String callbackTopic;
    /** 结果回调tag 非必传 */
    private String callbackTag;
    /** 需要回调的业务参数 非必传 */
    private String transfer;
    /**
     * 对外扣积分请求会携带此字段 非必传
     * 若此字段为空 则会传输 activityTitle 字段
     * 若 activityTitle 为空 则....则不下去了
     * */
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityTitle() {
        return activityTitle;
    }

    public void setActivityTitle(String activityTitle) {
        this.activityTitle = activityTitle;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public RequestParams getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    @Override
    public String toString() {
        return "AddCreditsRequest{" +
                "orderNum='" + orderNum + '\'' +
                ", credits=" + credits +
                ", appId=" + appId +
                ", consumerId=" + consumerId +
                ", partnerUserId='" + partnerUserId + '\'' +
                ", activityId=" + activityId +
                ", operatingActivityId=" + operatingActivityId +
                ", activityType='" + activityType + '\'' +
                ", activityTitle='" + activityTitle + '\'' +
                ", prizeId=" + prizeId +
                ", prizeName='" + prizeName + '\'' +
                ", requestParams=" + requestParams +
                ", callbackTopic='" + callbackTopic + '\'' +
                ", callbackTag='" + callbackTag + '\'' +
                ", transfer='" + transfer + '\'' +
                '}';
    }
}
