package cn.com.duiba.prize.center.api.enums;

/**
 * 奖品类型
 */
public enum DuibaPrizeTypeEnum {
    OBJECT("object","实物"),
    ALIPAY("alipay","支付宝"),
    QB("qb","QQ币"),
    PHONE_BILL("phonebill","话费"),
    COUPON("coupon","优惠劵"),
    VIRTUAL_ITEM("virtual","虚拟商品"),
    COLLECT_GOODS("collectGoods","集卡"),
    THANKS("thanks", "谢谢参与"),
    TRY_AGAIN("again", "再来一次"),
    LUCK_BAG("lucky", "福袋");

    private String type;
    private String desc;

    DuibaPrizeTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }


    /**
     * 判断type是否数据枚举中定义的type
     *
     * @param type
     * @return
     */
    public static boolean isIncludeSpecialType(String type) {
        return DuibaPrizeTypeEnum.THANKS.type.equals(type)
                || DuibaPrizeTypeEnum.TRY_AGAIN.type.equals(type)
                || DuibaPrizeTypeEnum.LUCK_BAG.type.equals(type);
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
