package cn.com.duiba.prize.center.api.enums.provide;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

public enum ProvidePrizeDegradedStrategyEnum {

    THANKS(1, "出奖过程出现异常,将降级为谢谢参与作为奖品"),
    ;

    private static final ImmutableMap<Integer, ProvidePrizeDegradedStrategyEnum> MAPPINGS;

    static {
        Map<Integer, ProvidePrizeDegradedStrategyEnum> temp = Maps.newHashMap();
        for (ProvidePrizeDegradedStrategyEnum e : values()) {
            temp.put(e.getCode(), e);
        }
        MAPPINGS = ImmutableMap.copyOf(temp);
    }

    public static ProvidePrizeDegradedStrategyEnum getByCode(Integer code) {
        return MAPPINGS.get(code);
    }

    private Integer code;

    private String desc;

    ProvidePrizeDegradedStrategyEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
