package cn.com.duiba.prize.center.api.remoteservice.projectx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.PrizeResultBaseDto;
import cn.com.duiba.prize.center.api.dto.projectx.AwardRequest;
import cn.com.duiba.prize.center.api.dto.projectx.DeductCreditsRequest;
import cn.com.duiba.prize.center.api.dto.projectx.FailStockResult;
import cn.com.duiba.prize.center.api.dto.projectx.PrizeRecordConsumerCount;
import cn.com.duiba.prize.center.api.dto.projectx.PrizeRecordDto;
import cn.com.duiba.prize.center.api.dto.projectx.UpdateStockRequest;
import cn.com.duiba.prize.center.api.dto.projectx.WithHoldingStockDto;

import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2019/06/27
 */
@AdvancedFeignClient
public interface RemoteProjectXService {

    /**
     * 获取优惠券信息
     * @param consumerId consumer id
     * @param projectOrderNo project order no
     * @param appId
     * @param floatingId 弹窗id
     * @return Lottery
     * @throws BizException bizException
     */
    PrizeResultBaseDto getLuckBagInfo(Long consumerId,Long appId, String projectOrderNo, String floatingId) throws BizException;

    /**
     * 获取优惠券信息
     * @param consumerId consumer id
     * @param projectOrderNo project order no
     * @param userAgent user agent
     * @param floatingId 弹窗id
     * @return Lottery
     * @throws BizException bizException
     */
    PrizeResultBaseDto.Lottery getCouponInfo(Long consumerId, String projectOrderNo, String userAgent, String floatingId) throws BizException;
    /**
     * 释放项目锁定库存
     * @param projectId 项目id
     * @param itemIdList item id list
     */
    void releaseWithHoldingStock(String projectId, List<Long> itemIdList);
    /**
     * 项目扣积分
     * @param request 扣积分请求
     * @throws BizException 异常
     */
    void deductCredits(DeductCreditsRequest request) throws BizException;

    /**
     * 项目发奖
     * @param request 发奖请求
     * @return prize record id
     * @throws BizException 异常
     */
    Long award(AwardRequest request) throws BizException;

    /**
     * 扣除或增加扣除
     * @param projectId project-x id
     * @param stockRequestList 扣库存请求
     * @return 失败列表
     * @throws BizException 异常
     */
    List<FailStockResult> batchDeductStock(String projectId, List<UpdateStockRequest> stockRequestList) throws BizException;

    /**
     * 批量获取预扣库存
     * @param itemIds itemIds
     * @return list
     */
    List<WithHoldingStockDto> getWithHoldingStock(List<Long> itemIds);

    /**
     * 获取发奖记录
     * @param projectOrderNo projectOrderNo
     * @return dto
     */
    PrizeRecordDto findPrizeRecordByProjectOrderNo(String projectOrderNo);

    /**
     * 获取发奖记录
     * @param id id
     * @return dto
     */
    PrizeRecordDto findPrizeRecordById(Long id);

    /**
     * 更新领奖记录
     * @param id prize record id
     * @param orderNo order no
     * @return 返回影响行数
     */
    Integer update2Success(Long id, String orderNo);

    /**
     * 更新为领奖中
     * @param id prize record id
     * @return 影响行数
     */
    Integer update2Drawing(Long id);

    /**
     * 回滚状态到待领奖
     * @param id id
     * @return 影响行数
     */
    Integer updateDrawing2ToDraw(Long id);

    /**
     * 手动领奖
     * @param request request
     * @return 自动发奖类型的会给主订单orderId，其他类型返回prize record id
     * @throws BizException exception
     */
    Long takePrize(AwardRequest request) throws BizException;

    /**
     * 批量查询发奖记录
     * @param projectOrderNos
     * @return
     */
    List<PrizeRecordDto> selectPrizeRecordByProjectOrderNos(List<String> projectOrderNos);

    /**
     * 统计中奖人数、领奖人数
     * @param start 开始时间
     * @param end 解释时间
     * @return
     * @throws BizException
     */
    List<PrizeRecordConsumerCount> statisticActivityAwardCountGroupByAppIdProjectId(Date start, Date end) throws BizException;
}
