package cn.com.duiba.prize.center.api.remoteservice.projectx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.projectx.SwitchConfigDto;
import cn.com.duiba.prize.center.api.enums.projectx.SwitchTypeEnum;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2020/4/1
 */
@AdvancedFeignClient
public interface RemoteSwitchConfigService {

    /**
     * 创建开关配置
     * @param switchConfigDto
     * @return
     */
    Long create(SwitchConfigDto switchConfigDto);

    /**
     * 获取开关配置信息
     * @param projectId
     * @return
     */
    List<SwitchConfigDto> getSwitchConfigs(String projectId);

    /**
     * 获取开关配置
     * @param projectId
     * @param switchTypeEnum
     * @return
     */
    SwitchConfigDto getSwitchConfig(String projectId, SwitchTypeEnum switchTypeEnum);

    /**
     * 修改开关配置
     * @param projectId
     * @param switchTypeEnum
     * @param switchStatus
     * @return
     */
    boolean update(String projectId, SwitchTypeEnum switchTypeEnum, boolean switchStatus);
}
