package cn.com.duiba.prize.center.api.dto.prize;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.prize.center.api.enums.credits.CreditsOperationTypeEnum;
import cn.com.duiba.prize.center.api.enums.credits.RecordStatusEnum;

import java.io.Serializable;

public class CreditsInfo implements Serializable {

    private static final long serialVersionUID = 6331066338711280926L;

    private Long activityId;
    private Long prizeId;
    private String orderNum;
    private String developerBizId;
    private Long score;
    private String errorMsg;

    /**
     * 积分操作结果
     *
     * @see RecordStatusEnum#getCode()
     */
    private Integer recordStatus;

    /**
     * 操作类型
     *
     * @see CreditsOperationTypeEnum#getType()
     */
    private Integer operationType;

    /**
     * 活动类型
     *
     * @see ActivityUniformityTypeEnum#getCode()
     */
    private Integer activityType;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(Long prizeId) {
        this.prizeId = prizeId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public Long getScore() {
        return score;
    }

    public void setScore(Long score) {
        this.score = score;
    }

    public Integer getRecordStatus() {
        return recordStatus;
    }

    public void setRecordStatus(Integer recordStatus) {
        this.recordStatus = recordStatus;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Integer getOperationType() {
        return operationType;
    }

    public void setOperationType(Integer operationType) {
        this.operationType = operationType;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }
}