package cn.com.duiba.prize.center.api.remoteservice.credits;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.credits.SimpleCreditsOperationParams;
import cn.com.duiba.prize.center.api.dto.prize.CreditsInfo;

/**
 * @Author: fxr
 * @Date: 2019/3/13
 */
@AdvancedFeignClient
public interface RemoteCreditsInnerJoinRecordService {

    /**
     * 1.插入积分操作记录
     * 2.通过mq向thirdparty-service发送扣积分消息
     *
     * 返回订单号：orderNum
     * @param entity
     * @return
     */
    String saveAddCreditsRecordThenSubmitRequst(SimpleCreditsOperationParams entity);

    /**
     * 获取积分操作结果信息
     *
     * @param consumerId
     * @param orderId
     * @return
     */
    CreditsInfo getCreditsInfo(Long consumerId, String orderId);
}
