package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.ActivityCommonOptionDto;
import cn.com.duiba.prize.center.api.dto.prize.ActivityOptionsDto;
import cn.com.duiba.prize.center.api.params.prize.PrizeSaveParam;

import java.util.List;

/**
 * ClassName:RemoteActivityOptionBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 兑吧活动工具奖项配置
 * @date 创建时间：2018/3/22  17:10
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityOptionBackendService {

    /**
     * 保存或新增奖项
     */
    void saveOrUpdateCommonPrize(PrizeSaveParam param) throws BizException;

    /**
     * 查询奖项列表
     * @param relationId   关联活动id
     * @param relationType  关联活动类型
     * @return
     */
    List<ActivityCommonOptionDto> findAllCommonPrize(Long relationId, String relationType);

    /**
     * 保存或新增奖项
     */
    Long saveOrUpdateHdToolOptions(ActivityOptionsDto param,Boolean newHdtool,Long hdtoolId);

    /**
     * 保存或新增奖项
     */
    void deleateHdtoolOptions(Long hdtoolId,List<Long> optionIds);
    
    /**
     * 查询奖品信息
     */
    List<ActivityOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId);
}
