package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.prize.ActivityPrizeProviderDto;
import cn.com.duiba.prize.center.api.request.provideprize.ProvidePrizeRequest;
import cn.com.duiba.prize.center.api.response.provideprize.ProvidePrizeResponse;

import java.util.List;

/**
 * 获取 自定义实现的奖品工厂key
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeProviderService {
	
	/**
	 * 获取所有 自定义发放奖品工厂配置
	 * 
	 * @return
	 * @since JDK 1.8
	 */
	List<ActivityPrizeProviderDto> getAllCustomProvider();

	/**
	 * 同步发奖接口
	 */
	ProvidePrizeResponse providePrize(ProvidePrizeRequest request);


}
