package cn.com.duiba.prize.center.api.remoteservice.actprestock;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.stock.ActPreStockDto;

import java.util.List;

/**
 * Created by hww on 2018/7/24 下午3:56.
 */
@AdvancedFeignClient
public interface RemoteActPreStockService {

    List<ActPreStockDto> findPreStockListByPrizeIds(List<Long> relationPrizeIds, String relationType, Long appId);

    /**
     * 扣库存
     * @param prizeId 奖项ID
     * @param bizId 订单ID
     * @param bizSource 订单来源
     * @param appId appID
     * @param consumeType
     * @see cn.com.duiba.stock.service.api.constant#ConsumeStockTypes
     * @throws BizException
     */
    void consumeActStock(Long prizeId, String bizId, String bizSource,Long appId, int consumeType) throws BizException;

    /**
     * 回滚库存
     * @param prizeId 奖品ID
     * @param bizId 订单ID
     * @param bizSource 订单来源
     * @param appId appID
     * @param consumeType
     * @see cn.com.duiba.stock.service.api.constant#ConsumeStockTypes
     * @throws BizException
     */
    void paybackActStock(Long prizeId,String bizId, String bizSource, Long appId, int consumeType) throws BizException;
}
