package cn.com.duiba.prize.center.api.enums;

/**
 * @author zhangruofan
 * @date 2019/07/05
 */
public enum DrawStatusEnum {
    /**
     * 初始化状态
     */
    INIT(0),
    /**
     * 待领取
     */
    TO_DRAW(1),
    /**
     * 领取中
     */
    DRAWING(2),
    /**
     * 已领取
     */
    DRAW_DOWN(3),
    /**
     * 领取失败
     */
    DRAW_FAIL(4),
    /**
     * 逾期未领取
     */
    OVERDUE(5),
    ;
    private Integer code;

    DrawStatusEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }
}
