package cn.com.duiba.prize.center.api.remoteservice.prize;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.mq.MqDataParam;

/**
 * ClassName:RemoteActivityTakePrizeService<br/>
 *
 *  活动工具--闯关游戏 直接指定奖品出奖品
 *
 * @author gey
 * @version 1.0
 * @date 创建时间：2018/4/22  17:13
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteActivityTakePrizeService {

	/**
	 *
	 * takePrize:活动工具领取指定奖品 <br/>
	 *
	 * @param prizeId
	 * @param param
	 *
	 * @return
	 * @since JDK 1.6
	 */
	public void takePrizeApi(Long prizeId,MqDataParam param) throws BizException;

	/**
	 *
	 * takePrizePlugin:利用 插件订单 直接发放 指定itemId 奖品  不扣库存  出错 不做奖品降级 <br/>
	 *
	 * @param itemId
	 * @param param
	 *
	 * @return
	 * @since JDK 1.6
	 */
	public Boolean takePrizePluginApi(Long itemId,MqDataParam param) throws BizException;
}
