package cn.com.duiba.prize.center.api.remoteservice.projectx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.prize.center.api.dto.projectx.AwardRequest;
import cn.com.duiba.prize.center.api.dto.projectx.DeductCreditsRequest;
import cn.com.duiba.prize.center.api.dto.projectx.FailStockResult;
import cn.com.duiba.prize.center.api.dto.projectx.PrizeRecordDto;
import cn.com.duiba.prize.center.api.dto.projectx.UpdateStockRequest;
import cn.com.duiba.prize.center.api.dto.projectx.WithHoldingStockDto;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2019/06/27
 */
@AdvancedFeignClient
public interface RemoteProjectXService {
    /**
     * 项目扣积分
     * @param request 扣积分请求
     * @throws BizException 异常
     */
    void deductCredits(DeductCreditsRequest request) throws BizException;

    /**
     * 项目发奖
     * @param request 发奖请求
     * @return prize record id
     * @throws BizException 异常
     */
    Long award(AwardRequest request) throws BizException;

    /**
     * 扣除或增加扣除
     * @param projectId project-x id
     * @param stockRequestList 扣库存请求
     * @return 失败列表
     * @throws BizException 异常
     */
    List<FailStockResult> batchDeductStock(String projectId, List<UpdateStockRequest> stockRequestList) throws BizException;

    /**
     * 批量获取预扣库存
     * @param itemIds itemIds
     * @return list
     */
    List<WithHoldingStockDto> getWithHoldingStock(List<Long> itemIds);

    /**
     * 获取发奖记录
     * @param projectOrderNo projectOrderNo
     * @return dto
     */
    PrizeRecordDto findPrizeRecordByProjectOrderNo(String projectOrderNo);

    /**
     * 获取发奖记录
     * @param id id
     * @return dto
     */
    PrizeRecordDto findPrizeRecordById(Long id);
}
