package cn.com.duiba.prize.center.api.request.provideprize;

import cn.com.duiba.biz.tool.duiba.dto.RequestParams;
import cn.com.duiba.prize.center.api.request.PrizeCenterRequest;

public abstract class ProvidePrizeRequest extends PrizeCenterRequest {

    private static final long serialVersionUID = -8568199091617234462L;

    /** 应用id 必传 */
    private Long appId;
    /** 兑吧用户id 必传 */
    private Long consumerId;
    /** 开发者用户id 必传 */
    private String partnerUserId;
    /** 活动类型 必传
     * @see cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     * */
    private String activityType;

    /*  ------  两个id必传一个 ↓  ------ */
    /** 兑吧活动id 必传1/2 */
    private Long activityId;
    /** 入库活动id 必传1/2 */
    private Long operatingActivityId;
    /*  ------  两个id必传一个 ↑ ------ */

    /** 活动名称 非必传 */
    private String activityName;
    /** 奖项名称 非必传 */
    private String prizeName;
    /** 开奖结果回调topic 非必传 */
    private String callbackTopic;
    /** 开奖结果回调tag 非必传 */
    private String callbackTag;
    /** 透传业务参数 开奖回调中返回 非必传 */
    private String transfer;
    /** RequestParams.parse()方法解析request  非必传 */
    private RequestParams requestParams;
    /** 活动子订单id 可以指定这条订单进行出奖 非必传 */
    private String orderId;
    /**
     * 指定降级策略
     * @see cn.com.duiba.prize.center.api.enums.provide.ProvidePrizeDegradedStrategyEnum
     * 非必传  若不执行降级策略 如果发奖失败 则终止发奖 并返回发奖失败
     * */
    private Integer degradedStrategy;
    /**
     * 开发者订单号(目前只能通过扣积分接口获取)
     * 部分开发者在发放虚拟商品时需要携带他们的bizId
     * 非必传
     */
    private String bizId;
    /**
     * 虚拟商品和优惠券 发奖后时候需要自动领奖
     * 非必传  默认需要
     */
    private boolean autoTakePrize = true;

    /**
     * 兑换记录标签  非必传
     * 用于实现只展示单一活动的中奖兑换记录功能
     * 上游需要传入此字段，在发奖成功生成兑换记录时会保存
     * 上游需要提前定义好自己的类型  以防冲突
     * http://cf.dui88.com/pages/viewpage.action?pageId=7682671
     */
    private Long origin;

    public Long getOrigin() {
        return origin;
    }

    public void setOrigin(Long origin) {
        this.origin = origin;
    }

    public boolean isAutoTakePrize() {
        return autoTakePrize;
    }

    public void setAutoTakePrize(boolean autoTakePrize) {
        this.autoTakePrize = autoTakePrize;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getDegradedStrategy() {
        return degradedStrategy;
    }

    public void setDegradedStrategy(Integer degradedStrategy) {
        this.degradedStrategy = degradedStrategy;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public RequestParams getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public String getCallbackTopic() {
        return callbackTopic;
    }

    public void setCallbackTopic(String callbackTopic) {
        this.callbackTopic = callbackTopic;
    }

    public String getCallbackTag() {
        return callbackTag;
    }

    public void setCallbackTag(String callbackTag) {
        this.callbackTag = callbackTag;
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public abstract String getApiMethodName();
}
