package cn.com.duiba.projectx.api.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ProjectSaveDto.java , v 0.1 2020-03-23 2:31 下午 ZhouFeng Exp $
 */
public class ProjectSaveDto implements Serializable {
    private static final long serialVersionUID = -1384907506763318291L;

    /**
     * 项目id
     */
    private String id;
    /**
     * 基本信息(json序列化)
     *
     * @see ProjectBasicInfoDto
     */
    private String baseInfo;
    /**
     * 项目配置
     */
    private String attributes;

    /**
     * 操作人userid
     */
    private Long userId;

    /**
     * 发起人身份 1：开发 2：运营
     */
    private Integer initiator;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBaseInfo() {
        return baseInfo;
    }

    public void setBaseInfo(String baseInfo) {
        this.baseInfo = baseInfo;
    }

    public String getAttributes() {
        return attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getInitiator() {
        return initiator;
    }

    public void setInitiator(Integer initiator) {
        this.initiator = initiator;
    }
}
