package cn.com.duiba.projectx.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.projectx.api.dto.ProjectOperateConfigDto;

import java.util.List;

/**
 * @author jiaxz
 * @since 2022-08-10
 * 项目维度配置管理
 */
@AdvancedFeignClient
public interface RemoteOperateService {


    /**
     * 查询运营配置项。
     * 目前只返回默认通用选项:免费次数、抽奖积分、限制次数
     * @see cn.com.duiba.projectx.api.eum.MngConfigKey
     * @param projectId
     * @param varKeys MngConfigKey对varKey的集合
     * @return
     */
    List<ProjectOperateConfigDto> getProjectVarConfig(String projectId,List<String> varKeys);

    /**
     * 修改模板活动运营配置项。
     * 目前允许修改内容:免费次数、抽奖积分、限制次数
     * @param projectId 项目id
     * @param operateConfigDtos  ProjectOperateConfigDto的集合，只需填写variable和value
     * @return
     */
    boolean updateProjectVarConfig(String projectId,List<ProjectOperateConfigDto> operateConfigDtos);

    /**
     * 获取项目可用状态
     * @param projectId 项目id
     * @return 上架中为true 否则为false
     */
    boolean getEnable(String projectId);

    /**
     * 设置项目上下架状态
     * @param projectId 项目id
     * @param enable true时为上架，false时下架
     * @return 操作结果，true成功；false失败
     */
    boolean updateEnable(String projectId, boolean enable);
}
