package cn.com.duiba.projectx.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: ProjectDto
 * @Description:项目信息
 * @date 2019/9/410:04
 */

public class ProjectDto implements Serializable {
    private static final long serialVersionUID = -5275228401804508958L;

    private Long id;

    private String projectId; //项目ID

    private Long projectIdNum; //项目ID数字类型

    private String projectName; //项目名称

    private Long appId; //应用ID

    private Date startTime; //项目开始时间

    private Date endTime; //项目结束时间

    private Integer state; //项目状态 0:创建，1:上架，2:下架，3:终止

    private String attributes; //项目配置数据

    private Date gmtCreate; //创建时间

    private Date gmtModified; //变更时间

    /**
     * 是否模板活动，0:否，1：是，表字段默认0
     */
    private Integer templateProject;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Long getProjectIdNum() {
        return projectIdNum;
    }

    public void setProjectIdNum(Long projectIdNum) {
        this.projectIdNum = projectIdNum;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getAttributes() {
        return attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getTemplateProject() {
        return templateProject;
    }

    public void setTemplateProject(Integer templateProject) {
        this.templateProject = templateProject;
    }
}
