package cn.com.duiba.projectx.api.dto;

/**
 * 项目状态枚举
 *
 * @Author: xuwei
 *
 */
public enum ProjectStateEnum {
    CREATED(0, "已创建"),
    ON(1, "上架中"),
    OFF(2, "已下架"),
    TERMINATED(3, "已终止");

    private Integer code;
    private String desc;

    ProjectStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取指定类型的枚举
     *
     * @param code
     * @return
     */
    public static ProjectStateEnum ofCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ProjectStateEnum state : values()) {
            if (state.code.equals(code)) {
                return state;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
