package cn.com.duiba.projectx.sdk.demo;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.annotation.CustomRequestAction;
import cn.com.duiba.projectx.sdk.playway.scoring.ScoringPlaywayInstance;
import cn.com.duiba.projectx.sdk.playway.scoring.ScoringUserRequestApi;
import cn.com.duiba.projectx.sdk.playway.scoring.StartRecord;
import cn.com.duiba.projectx.sdk.utils.RankingApi;


public class ScoringDemo extends ScoringPlaywayInstance{

    private static final boolean high2low=true;

    @Override
    public void config(ScoringConfig config) {
        config.setAllowMultiSubmit(true);
    }

    @Override
    public Object start(UserRequestContext context, ScoringUserRequestApi api) {
        return api.getCurrentRecordId();
    }

    @Override
    public Object submit(StartRecord startRecord, int score, UserRequestContext context, ScoringUserRequestApi api) {
        //提交分数
        api.submitScore(startRecord.getStartId(), score);
        //更新排行榜
        RankingApi rankingApi= api.getRankingApi();
        rankingApi.updateRankingScore("type",score,high2low);


        return "ok";
    }


    @CustomRequestAction(id="ok",name = "ok")
    public Object ok(UserRequestContext context,ScoringUserRequestApi api){
        return 666;
    }
}
