/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;

public class Conditions {
    public static void expectFalse(boolean expression, String errorMessage) {
        Conditions.expectFalse(expression, ErrorCode.ERR_10000, errorMessage);
    }

    public static void expectFalse(boolean expression, int errorCode, String errorMessage) {
        if (expression) {
            throw new BizRuntimeException(errorCode, errorMessage);
        }
    }

    public static void expectAllTrue(String errorMessage, boolean ... expressions) {
        Conditions.expectAllTrue(ErrorCode.ERR_10000, errorMessage, expressions);
    }

    public static void expectAllTrue(int errorCode, String errorMessage, boolean ... expressions) {
        for (boolean b : expressions) {
            Conditions.expectTrue(b, errorCode, errorMessage);
        }
    }

    public static void expectTrue(boolean expression, String errorMessage) {
        Conditions.expectTrue(expression, ErrorCode.ERR_10000, errorMessage);
    }

    public static void expectTrue(boolean expression, int errorCode, String errorMessage) {
        if (!expression) {
            throw new BizRuntimeException(errorCode, errorMessage);
        }
    }

    public static <T> T expectNotNull(T reference, String errorMessage) {
        return Conditions.expectNotNull(reference, ErrorCode.ERR_10000, errorMessage);
    }

    public static <T> T expectNotNull(T reference, int code, String errorMessage) {
        if (reference == null) {
            throw new BizRuntimeException(code, errorMessage);
        }
        return reference;
    }
}

