package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.backend.ranking.ManualSendPrizeCallable;

/**
 * 后台手动开奖API
 * @author zhangruofan
 * @date 2019/10/24
 */
public interface BackendRankingApi {
    /**
     * 直接发奖
     * @param strategyId 直接出奖策略id
     * @param userId 用户id
     * @param prizeId 奖品Id
     * @return 发奖是否成功
     */
    boolean sendPrize(String strategyId, String userId, String prizeId);

    /**
     * 执行开奖逻辑
     * @param type 排行榜type
     * @param topN 获取前几名开奖
     * @param callable 开奖回调
     */
    void manualSendPrize(String type, int topN,  ManualSendPrizeCallable callable);
}
