package cn.com.duiba.projectx.sdk;

import cn.com.duiba.projectx.sdk.playway.base.UserContext;
import cn.com.duiba.projectx.sdk.template.DistributedLock;
import cn.com.duiba.projectx.sdk.template.RedisLock;
import cn.com.duiba.projectx.sdk.utils.DuibaApi;
import cn.com.duiba.projectx.sdk.utils.ProjectApi;
import cn.com.duiba.projectx.sdk.utils.RankingApi;
import cn.com.duiba.projectx.sdk.utils.UserDataApi;
import cn.com.duiba.projectx.sdk.utils.UserLock;
import cn.com.duiba.projectx.sdk.utils.UserRelationApi;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 用户请求作用域内可使用的API
 *
 * @author xuhengfei
 */
public interface UserRequestApi extends Api {

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    boolean useCreditsTicket(String ticketNum);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获得当前Action自动生成的记录ID
     * (预设接口内才能获取到，自定义接口中无法获取到)
     *
     * @return 记录ID
     */
    Long getCurrentRecordId();

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 使用发奖策略出奖
     * 可以指定一个用户进行策略发奖
     *
     * @param userId
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult sendPrizeWithStrategy(String userId,String prizeStrategyId);

    /**
     * 给当前用户发放一个道具
     *
     * @param spId     道具ID
     * @param quantity 初始化属性值
     * @return 记录ID
     */
    Long giveStageProperty(String spId, int quantity);

    /**
     * 消耗当前用户的道具
     *
     * @param spId     道具ID
     * @param quantity 属性减少数量
     * @return
     */
    Boolean consumeStageProperty(String spId, int quantity);

    /**
     * 当前用户的道具属性增加
     *
     * @param spId     道具ID
     * @param quantity 属性增加数量
     * @param max   属性增加最大值  为NUll不限制最大
     * @return
     */
    @Deprecated
    Boolean stagePropertyIncr(String spId, int quantity, Long max);
    /**
     * 当前用户道具数据减少
     *
     * @param spId     道具ID
     * @param quantity 减少数量
     * @return
     */
    @Deprecated
    Boolean stagePropertyDecr(String spId, int quantity);

    /**
     * 修改覆盖道具属性
     *
     * @param spId
     * @param quantity
     * @return
     */
    @Deprecated
    Boolean updateStagePorperty(String spId, int quantity);
    /**
     * 查询用户某个道具属性
     *
     *
     * @param spId 道具ID
     * @return
     */
    @Deprecated
    Long queryStageProperty(String spId);

    /**
     * 批量查询用户道具属性
     *
     * @param spIds 道具ID集合
     * @return
     */
    @Deprecated
    Map<String, Long> queryStageProperty(List<String> spIds);

    /**
     * 直接发奖，不通过发奖规则进行发奖
     * @param customStrategyId 自定义策略id(不要使用界面配置的策略ID)，自行编造即可，不要重复
     * @param prizeId
     * @return
     */
    StrategyResult sendPrizeWithDirect(String customStrategyId,String prizeId);

    /**
     * 兑吧APP签名
     *
     * @param params 需要签名的参数
     * @return params 签名好的参数，里面会加入sign, appKey，timestamp
     * @deprecated 改用UserRequestApi.getDuibaApi().getSignApi().doSign()
     */
    @Deprecated
    Map<String, String> duibaSign(Map<String, String> params);

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     * @return
     */
    @Deprecated
    String getDuibaPartnerUserId();

    /**
     *
     * 如需防止用户并发行为，请优先使用@getUserLock()
     *
     * Redis:获取一个锁
     * 注：获得的锁对象（如果为null表示获取锁失败），后续可以调用该对象的unlock方法来释放锁
     *
     * @param key KEY
     * @param expireSeconds 失效时间
     * @return 锁对象
     */
    @Deprecated
    public RedisLock redisGetLock(final String key, long expireSeconds);

    /**
     *
     * 如需防止用户并发行为，请优先使用@getUserLock()
     *
     * Redis:获取一个锁
     * 注：获得的锁对象（如果为null表示获取锁失败），后续可以调用该对象的unlock方法来释放锁
     *
     * @param key KEY
     * @param expireSeconds 失效时间
     * @param maxRetryTimes 最大重试次数,如果获取锁失败，会自动尝试重新获取锁；
     * @param retryIntervalTimeMillis 每次重试之前sleep等待的毫秒数
     * @return
     */
    @Deprecated
    public RedisLock redisGetLock(final String key, long expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * Redis:计数器
     *
     * @param key KEY
     * @param delta 计数
     * @param timeout 失效时间
     * @param timeUnit 时间单位
     * @return 当前结果
     */
    @Deprecated
    public Long redisIncrBy(String key, long delta, long timeout, TimeUnit timeUnit);


    /**
     * 创建一个分布式锁对象
     *
     * @param key
     * @param expireSeconds 自动失效时间
     * @return
     */
    DistributedLock newLock(String key, int expireSeconds);

    /**
     * Redis: GetAtomicValue
     * @param key
     * @return
     */
    @Deprecated
    public Long redisGetAtomicValue(String key);

    /**
     * 获取用户锁接口
     *
     * 请使用 context.getUserLock()
     *
     * @return
     */
    @Deprecated
    public UserLock getUserLock();

    /**
     * 获取LoggerService
     * 日志类的方法接口
     * @return LoggerService
     */
    LoggerService getLoggerService();

    /**
     * 获取排行榜的服务接口
     * @return
     */
    RankingApi getRankingApi();

    UserRelationApi getUserRelationApi();

    /**
     * 请使用  getMyUserContext 替换此方法
     * @return
     */
    @Deprecated
    UserDataApi getUserDataApi();

    UserContext getMyUserContext();

    UserContext getUserContext(String userId);

    ProjectApi getProjectApi();

    DuibaApi getDuibaApi();
}
