package cn.com.duiba.projectx.sdk.annotation;

import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface CustomRequestAction {

    String id();

    String name();

    /**
     * 是否允许被合并到Merge接口中使用
     *
     * 一般允许使用的场景：
     * 1.查询接口，没有配置上下文
     *
     * @return
     */
    boolean allowMergeRequest() default false;

}
