package cn.com.duiba.projectx.sdk.template;

/**
 * 分布式锁对象
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: DistributedLock.java , v 0.1 2019-11-05 11:45 ZhouFeng Exp $
 */
public interface DistributedLock {

    /**
     * 尝试上锁
     * @return 是否上锁成功
     */
    boolean tryLock();

    /**
     * 尝试上锁
     *
     * @param maxRetryTimes           最大重试次数
     * @param retryIntervalTimeMillis 每次重试间隔（单位：毫秒）
     * @return
     */
    boolean tryLock(int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * 解锁
     */
    void unlock();

}
