package cn.com.duiba.projectx.sdk;

import javax.servlet.http.HttpServletRequest;

/**
 * 用户请求参数
 *
 * @author houwen
 */
public interface UserRequestContext {

    /**
     * HttpServletRequest
     *
     * @return
     */
    HttpServletRequest getHttpRequest();

    /**
     * 往上下文设置数据
     *
     * @param key
     * @param value
     */
    void setValue(String key, Object value);

    /**
     * 根据Key读取上下文中的数据
     *
     * @param key
     * @return
     */
    Object getValue(String key);

    String getUserId();

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     * @return
     */
    String getPartnerUserId();

}
