package cn.com.duiba.projectx.sdk.annotation;

import cn.com.duiba.projectx.sdk.riskmddata.MarkTypeEnum;
import cn.com.duiba.projectx.sdk.riskmddata.SendPrizeDecisionEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标识是否走风控
 * MarkTypeEnum枚举类型
 *   DEFAULT("0","默认(不走风控)"),
 *   ACCESS("1", "访问"),
 *   ACTIVITY("2", "活动参与"),
 *   REWARD("3", "奖励"),
 *   EXCHANGE("4", "兑换"),
 *   EXTRACTCASH("5", "提现"),
 *
 * SendPrizeDecisionEnum 枚举类型
 *    SENDPRIZEGORISK("6", "发奖走风控"),
 *    SENDPRIZENOGORISK("0", "发奖不走风控"),
 *
 * @see @EnableRiskControl(vaule = MarkTypeEnum.ACCESS,isSPtoRisk = SendPrizeDecisionEnum.SENDPRIZEGORISK)
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface EnableRiskControl {
    MarkTypeEnum value();
    SendPrizeDecisionEnum isSPtoRisk();
}
