package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;

public class Conditions {

    public static void expectFalse(boolean expression,String errorMessage){
        expectFalse(expression,ErrorCode.ERR_10000,errorMessage);
    }

    public static void expectFalse(boolean expression,int errorCode,String errorMessage){
        if(expression){
            throw new BizRuntimeException(errorCode,errorMessage);
        }
    }

    public static void expectAllTrue(String errorMessage,boolean... expressions){
        expectAllTrue(ErrorCode.ERR_10000,errorMessage,expressions);
    }
    public static void expectAllTrue(int errorCode,String errorMessage,boolean... expressions){
        for(boolean b:expressions){
            expectTrue(b,errorCode,errorMessage);
        }
    }

    public static void expectTrue(boolean expression,String errorMessage){
        expectTrue(expression,ErrorCode.ERR_10000,errorMessage);
    }

    public static void expectTrue(boolean expression,int errorCode,String errorMessage){
        if(!expression){
            throw new BizRuntimeException(errorCode,errorMessage);
        }
    }

    public static <T> T expectNotNull(T reference,String errorMessage) {
        return expectNotNull(reference,ErrorCode.ERR_10000,errorMessage);
    }

    public static <T> T expectNotNull(T reference,int code,String errorMessage) {
        if (reference == null) {
            throw new BizRuntimeException(code,errorMessage);
        } else {
            return reference;
        }
    }
}
