package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.playway.base.Prize;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;

import java.util.Date;

public interface ProjectApi extends Api {

    PrizeStock getPrizeStock(String prizeId);

    Prize getPrize(String prizeId);

    /**
     * @deprecated 改用ProjectApi.putKvStringData(String key, String value, Date expireTime)
     */
    @Deprecated
    void insertKvStringData(String key, String value, Date expireTime);

    /**
     * @deprecated 改用ProjectApi.putKvStringData(String key, String value, Date expireTime)
     */
    @Deprecated
    void putKvStringData(String key, String value);


    /**
     * 增加/减少数值
     *
     * @param key
     * @param offset 增量
     * @param expire 失效时间
     * @return 变更后的数值
     */
    long increase(String key, long offset, Date expire);


    /**
     * 获取kv中的数值
     *
     * @param key
     * @return 当值不存在时返回null，存在时返回实际数值
     */
    Long getKvLong(String key);

    /**
     * 添加/更新KV记录
     *
     * @param key
     * @param value
     * @param expireTime
     * @return
     */
    boolean putKvStringData(String key, String value, Date expireTime);

    /**
     * 获取kv记录
     *
     * @param key
     * @return
     */
    String getKvStringData(String key);

    /**
     * 给用户发放道具
     * @param userId userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);
}
