package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.wechat.MpUserinfoData;
import cn.com.duiba.projectx.sdk.wechat.WxReplyConfigData;
import cn.com.duiba.projectx.sdk.wechat.WxSceneIdGenParam;

/**
 * 微信接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WechatApi.java , v 0.1 2019-10-31 16:50 ZhouFeng Exp $
 */
public interface WechatApi {

    /**
     * 获取场景值
     * 分享时初始化分享数据，用于生成带参二维码
     *
     * @param param
     * @return
     */
    Long getSceneId(WxSceneIdGenParam param);


    /**
     * 插入微信事件回复内容配置
     *
     * @param data
     * @return
     */
    Long insert(WxReplyConfigData data);


    /**
     * 获取公众号下用户信息
     *
     * @param wechatAppId 微信公众号ID
     * @param openId      用户openID
     * @return 用户信息, 可能返回null
     */
    MpUserinfoData getUserinfo(String wechatAppId, String openId);


}
