/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.utils;

import java.util.List;

public class PageList<T> {
    private long totalCount;
    private long totalPage;
    private List<T> list;

    public PageList(long totalCount, long pageSize, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = this.totalPage(pageSize);
    }

    public static <T> PageList<T> of(long totalCount, long pageSize, List<T> list) {
        return new PageList<T>(totalCount, pageSize, list);
    }

    private long totalPage(long pageSize) {
        if (this.totalCount < 1L) {
            return 0L;
        }
        return this.totalCount % pageSize == 0L ? this.totalCount / pageSize : this.totalCount / pageSize + 1L;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public List<T> getList() {
        return this.list;
    }
}

